/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.freeform.spi.support;

import java.io.File;
import java.io.IOException;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.queries.CollocationQuery;
import org.netbeans.modules.ant.freeform.FreeformProject;
import org.netbeans.modules.ant.freeform.FreeformProjectGenerator;
import org.netbeans.modules.ant.freeform.spi.ProjectAccessor;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.xml.XMLUtil;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.SAXException;

public class Util {
    public static final String NAMESPACE = "http://www.netbeans.org/ns/freeform-project/2";
    private static Schema SCHEMA_1;
    private static Schema SCHEMA_2;

    private Util() {
    }

    public static AuxiliaryConfiguration getAuxiliaryConfiguration(AntProjectHelper helper) {
        try {
            Project p = ProjectManager.getDefault().findProject(helper.getProjectDirectory());
            AuxiliaryConfiguration aux = (AuxiliaryConfiguration)p.getLookup().lookup(AuxiliaryConfiguration.class);
            assert (aux != null);
            return aux;
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
            return null;
        }
    }

    public static String relativizeLocation(File projectBase, File freeformBase, File location) {
        if (CollocationQuery.areCollocated((File)projectBase, (File)location)) {
            if (projectBase.equals(freeformBase)) {
                return PropertyUtils.relativizeFile((File)projectBase, (File)location);
            }
            if (projectBase.equals(location) && "${project.dir}/".endsWith("/")) {
                return "${project.dir}/".substring(0, "${project.dir}/".length() - 1);
            }
            return "${project.dir}/" + PropertyUtils.relativizeFile((File)projectBase, (File)location);
        }
        return location.getAbsolutePath();
    }

    public static File resolveFile(PropertyEvaluator evaluator, File freeformProjectBase, String val) {
        String location = evaluator.evaluate(val);
        if (location == null) {
            return null;
        }
        return PropertyUtils.resolveFile((File)freeformProjectBase, (String)location);
    }

    public static File getProjectLocation(AntProjectHelper helper, PropertyEvaluator evaluator) {
        String loc = evaluator.getProperty("project.dir");
        if (loc != null) {
            return helper.resolveFile(loc);
        }
        return FileUtil.toFile((FileObject)helper.getProjectDirectory());
    }

    public static FileObject getDefaultAntScript(Project prj) throws IllegalArgumentException {
        ProjectAccessor accessor = (ProjectAccessor)prj.getLookup().lookup(ProjectAccessor.class);
        if (accessor == null) {
            throw new IllegalArgumentException("Only FreeformProjects are supported.");
        }
        return FreeformProjectGenerator.getAntScript(accessor.getHelper(), accessor.getEvaluator());
    }

    public static Element getPrimaryConfigurationData(final AntProjectHelper helper) {
        return (Element)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Element>(){

            public Element run() {
                AuxiliaryConfiguration ac = helper.createAuxiliaryConfiguration();
                Element data = ac.getConfigurationFragment("general-data", Util.NAMESPACE, true);
                if (data != null) {
                    return data;
                }
                return XMLUtil.translateXML((Element)helper.getPrimaryConfigurationData(true), (String)Util.NAMESPACE);
            }
        });
    }

    public static void putPrimaryConfigurationData(final AntProjectHelper helper, final Element data) {
        if (!data.getNamespaceURI().equals(NAMESPACE)) {
            throw new IllegalArgumentException("Bad namespace");
        }
        ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Void>(){

            public Void run() {
                Element dataAs1 = XMLUtil.translateXML((Element)data, (String)"http://www.netbeans.org/ns/freeform-project/1");
                if (SCHEMA_1 == null) {
                    try {
                        SchemaFactory f = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                        SCHEMA_1 = f.newSchema(FreeformProject.class.getResource("resources/freeform-project-general.xsd"));
                        SCHEMA_2 = f.newSchema(FreeformProject.class.getResource("resources/freeform-project-general-2.xsd"));
                    }
                    catch (SAXException e) {
                        Exceptions.printStackTrace((Throwable)e);
                        Util.putPrimaryConfigurationDataAs1(helper, dataAs1);
                    }
                }
                try {
                    XMLUtil.validate((Element)dataAs1, (Schema)SCHEMA_1);
                    Util.putPrimaryConfigurationDataAs1(helper, dataAs1);
                }
                catch (SAXException x1) {
                    try {
                        XMLUtil.validate((Element)data, (Schema)SCHEMA_2);
                        Util.putPrimaryConfigurationDataAs2(helper, data);
                    }
                    catch (SAXException x2) {
                        assert (false) : x2.getMessage() + "; rejected content: " + Util.format(data);
                        Util.putPrimaryConfigurationDataAs1(helper, dataAs1);
                    }
                }
                return null;
            }
        });
    }

    private static void putPrimaryConfigurationDataAs1(AntProjectHelper helper, Element data) {
        helper.createAuxiliaryConfiguration().removeConfigurationFragment("general-data", NAMESPACE, true);
        helper.putPrimaryConfigurationData(data, true);
    }

    private static void putPrimaryConfigurationDataAs2(AntProjectHelper helper, Element data) {
        Document doc = data.getOwnerDocument();
        Element dummy1 = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/1", "general-data");
        dummy1.appendChild(doc.createElementNS("http://www.netbeans.org/ns/freeform-project/1", "name")).appendChild(doc.createTextNode(XMLUtil.findText((Node)XMLUtil.findElement((Element)data, (String)"name", (String)NAMESPACE))));
        helper.putPrimaryConfigurationData(dummy1, true);
        helper.createAuxiliaryConfiguration().putConfigurationFragment(data, true);
    }

    private static String format(Element data) {
        LSSerializer ser = ((DOMImplementationLS)data.getOwnerDocument().getImplementation().getFeature("LS", "3.0")).createLSSerializer();
        try {
            ser.getDomConfig().setParameter("format-pretty-print", true);
            ser.getDomConfig().setParameter("xml-declaration", false);
        }
        catch (DOMException dOMException) {
            // empty catch block
        }
        return ser.writeToString(data);
    }
}

